/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city.cityhall.impl;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityHallNotice;
import ch.sahits.game.openpatrician.model.city.cityhall.IPikemen;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.CityGuard;
import ch.sahits.game.openpatrician.model.people.IContractBroker;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;

public class Pikemen
extends CityGuard
implements IPikemen {

    public static class CityHallNotice
    implements ICityHallNotice {
        private final IContractBroker contact;
        private final IWare requiredWare;
        private final ICity destination;
        private final AmountablePrice<IWare> wareAndAmount;

        CityHallNotice(IContractBroker contact, IWare requiredWare, ICity destination, AmountablePrice<IWare> wareAndAmount) {
            this.contact = contact;
            this.requiredWare = requiredWare;
            this.destination = destination;
            this.wareAndAmount = wareAndAmount;
        }

        public static CityHallNoticeBuilder builder() {
            return new CityHallNoticeBuilder();
        }

        @Override
        public IContractBroker getContact() {
            return this.contact;
        }

        @Override
        public IWare getRequiredWare() {
            return this.requiredWare;
        }

        @Override
        public ICity getDestination() {
            return this.destination;
        }

        @Override
        public AmountablePrice<IWare> getWareAndAmount() {
            return this.wareAndAmount;
        }

        public static class CityHallNoticeBuilder {
            private IContractBroker contact;
            private IWare requiredWare;
            private ICity destination;
            private AmountablePrice<IWare> wareAndAmount;

            CityHallNoticeBuilder() {
            }

            public CityHallNoticeBuilder contact(IContractBroker contact) {
                this.contact = contact;
                return this;
            }

            public CityHallNoticeBuilder requiredWare(IWare requiredWare) {
                this.requiredWare = requiredWare;
                return this;
            }

            public CityHallNoticeBuilder destination(ICity destination) {
                this.destination = destination;
                return this;
            }

            public CityHallNoticeBuilder wareAndAmount(AmountablePrice<IWare> wareAndAmount) {
                this.wareAndAmount = wareAndAmount;
                return this;
            }

            public CityHallNotice build() {
                return new CityHallNotice(this.contact, this.requiredWare, this.destination, this.wareAndAmount);
            }

            public String toString() {
                return "Pikemen.CityHallNotice.CityHallNoticeBuilder(contact=" + this.contact + ", requiredWare=" + this.requiredWare + ", destination=" + this.destination + ", wareAndAmount=" + this.wareAndAmount + ")";
            }
        }
    }
}

