/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city.cityhall.impl;

import ch.sahits.game.openpatrician.model.city.cityhall.ITreasury;

public class Tresury
implements ITreasury {
    private double currentHeadTaxValue = 4.0;
    private double currentPropertyTax = 280.0;
    private long paidTaxes = 0L;
    private long paidSpecialTaxes = 0L;
    private int cityGuardCosts = 0;
    private int buildingCosts = 0;
    private int outriggerCosts = 0;
    private int siegeCosts = 0;
    private int otherCosts = 0;
    private int otherIncome = 0;

    @Override
    public void update(long cash) {
        if (cash < 0L) {
            this.otherCosts = (int)((long)this.otherCosts - cash);
        } else {
            this.otherIncome = (int)((long)this.otherIncome + cash);
        }
    }

    Tresury(double currentHeadTaxValue, double currentPropertyTax, long paidTaxes, long paidSpecialTaxes, int cityGuardCosts, int buildingCosts, int outriggerCosts, int siegeCosts, int otherCosts, int otherIncome) {
        this.currentHeadTaxValue = currentHeadTaxValue;
        this.currentPropertyTax = currentPropertyTax;
        this.paidTaxes = paidTaxes;
        this.paidSpecialTaxes = paidSpecialTaxes;
        this.cityGuardCosts = cityGuardCosts;
        this.buildingCosts = buildingCosts;
        this.outriggerCosts = outriggerCosts;
        this.siegeCosts = siegeCosts;
        this.otherCosts = otherCosts;
        this.otherIncome = otherIncome;
    }

    public static TresuryBuilder builder() {
        return new TresuryBuilder();
    }

    @Override
    public double getCurrentHeadTaxValue() {
        return this.currentHeadTaxValue;
    }

    @Override
    public double getCurrentPropertyTax() {
        return this.currentPropertyTax;
    }

    @Override
    public long getPaidTaxes() {
        return this.paidTaxes;
    }

    @Override
    public long getPaidSpecialTaxes() {
        return this.paidSpecialTaxes;
    }

    @Override
    public int getCityGuardCosts() {
        return this.cityGuardCosts;
    }

    @Override
    public int getBuildingCosts() {
        return this.buildingCosts;
    }

    @Override
    public int getOutriggerCosts() {
        return this.outriggerCosts;
    }

    @Override
    public int getSiegeCosts() {
        return this.siegeCosts;
    }

    @Override
    public int getOtherCosts() {
        return this.otherCosts;
    }

    @Override
    public int getOtherIncome() {
        return this.otherIncome;
    }

    public static class TresuryBuilder {
        private double currentHeadTaxValue;
        private double currentPropertyTax;
        private long paidTaxes;
        private long paidSpecialTaxes;
        private int cityGuardCosts;
        private int buildingCosts;
        private int outriggerCosts;
        private int siegeCosts;
        private int otherCosts;
        private int otherIncome;

        TresuryBuilder() {
        }

        public TresuryBuilder currentHeadTaxValue(double currentHeadTaxValue) {
            this.currentHeadTaxValue = currentHeadTaxValue;
            return this;
        }

        public TresuryBuilder currentPropertyTax(double currentPropertyTax) {
            this.currentPropertyTax = currentPropertyTax;
            return this;
        }

        public TresuryBuilder paidTaxes(long paidTaxes) {
            this.paidTaxes = paidTaxes;
            return this;
        }

        public TresuryBuilder paidSpecialTaxes(long paidSpecialTaxes) {
            this.paidSpecialTaxes = paidSpecialTaxes;
            return this;
        }

        public TresuryBuilder cityGuardCosts(int cityGuardCosts) {
            this.cityGuardCosts = cityGuardCosts;
            return this;
        }

        public TresuryBuilder buildingCosts(int buildingCosts) {
            this.buildingCosts = buildingCosts;
            return this;
        }

        public TresuryBuilder outriggerCosts(int outriggerCosts) {
            this.outriggerCosts = outriggerCosts;
            return this;
        }

        public TresuryBuilder siegeCosts(int siegeCosts) {
            this.siegeCosts = siegeCosts;
            return this;
        }

        public TresuryBuilder otherCosts(int otherCosts) {
            this.otherCosts = otherCosts;
            return this;
        }

        public TresuryBuilder otherIncome(int otherIncome) {
            this.otherIncome = otherIncome;
            return this;
        }

        public Tresury build() {
            return new Tresury(this.currentHeadTaxValue, this.currentPropertyTax, this.paidTaxes, this.paidSpecialTaxes, this.cityGuardCosts, this.buildingCosts, this.outriggerCosts, this.siegeCosts, this.otherCosts, this.otherIncome);
        }

        public String toString() {
            return "Tresury.TresuryBuilder(currentHeadTaxValue=" + this.currentHeadTaxValue + ", currentPropertyTax=" + this.currentPropertyTax + ", paidTaxes=" + this.paidTaxes + ", paidSpecialTaxes=" + this.paidSpecialTaxes + ", cityGuardCosts=" + this.cityGuardCosts + ", buildingCosts=" + this.buildingCosts + ", outriggerCosts=" + this.outriggerCosts + ", siegeCosts=" + this.siegeCosts + ", otherCosts=" + this.otherCosts + ", otherIncome=" + this.otherIncome + ")";
        }
    }
}

