/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.model.GameFactory;
import ch.sahits.game.openpatrician.model.IMap;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.impl.CityState;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.util.GenericPair;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Lazy
@Component
public class CitiesState {
    @Autowired
    private IMap map;
    @Autowired
    private Random rnd;
    @Autowired
    private GameFactory gameFactory;
    private ConcurrentHashMap<ICity, CityState> cities = new ConcurrentHashMap();

    @PostConstruct
    public void init() {
        for (ICity city : this.map.getCities()) {
            CityState cityState = this.gameFactory.getCityState(city);
            this.cities.put(city, cityState);
        }
    }

    public Optional<GenericPair<ICity, IWare>> findCityWithMostNeededWare() {
        ArrayList<GenericPair> all = new ArrayList<GenericPair>();
        for (CityState state : this.cities.values()) {
            Optional<IWare> ware = state.findMostNeededWare();
            if (!ware.isPresent()) continue;
            all.add(new GenericPair((Object)state.getCity(), ware.get()));
        }
        if (all.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of(all.get(this.rnd.nextInt(all.size())));
    }

    public Optional<GenericPair<ICity, IWare>> findCityWithSurplusWare() {
        ArrayList<GenericPair> all = new ArrayList<GenericPair>();
        for (CityState state : this.cities.values()) {
            Optional<IWare> ware = state.findWareWithMostSurplus();
            if (!ware.isPresent()) continue;
            all.add(new GenericPair((Object)state.getCity(), ware.get()));
        }
        if (all.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of(all.get(this.rnd.nextInt(all.size())));
    }

    public List<CityState> getCityEngineStates() {
        return ImmutableList.copyOf(this.cities.values());
    }
}

