/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.impl.DailyContribution;
import ch.sahits.game.openpatrician.model.product.IWare;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.joda.time.DateTimeComparator;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
public class Contributions {
    private final DailyContribution[] contributions = new DailyContribution[]{new DailyContribution(), new DailyContribution(), new DailyContribution(), new DailyContribution(), new DailyContribution(), new DailyContribution(), new DailyContribution()};
    @Autowired
    private Date date;
    private DateTime lastDate;
    private DateTimeComparator comperator = DateTimeComparator.getDateOnlyInstance();

    @PostConstruct
    private void init() {
        this.lastDate = this.date.getCurrentDate();
    }

    public int getContribution(IWare ware) {
        int sum = 0;
        for (DailyContribution contrib : this.contributions) {
            sum += contrib.getContribution(ware);
        }
        return sum;
    }

    public void contribute(IWare ware, int amount) {
        int index = this.date.getWeekdayIndex();
        DateTime now = this.date.getCurrentDate();
        if (this.comperator.compare((Object)this.lastDate, (Object)now) != 0) {
            this.contributions[index] = new DailyContribution();
            this.lastDate = now;
        }
        this.contributions[index].contribute(ware, amount);
    }
}

