/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.city.ICreditor;
import ch.sahits.game.openpatrician.model.city.impl.IDebt;
import java.beans.ConstructorProperties;
import org.joda.time.DateTime;

public class Debt
implements IDebt {
    private final ICitizen debitor;
    private final ICreditor creditor;
    private final DateTime dueDate;
    private final double interest;
    private final int amount;

    public static DebtBuilder builder() {
        return new DebtBuilder();
    }

    @ConstructorProperties(value={"debitor", "creditor", "dueDate", "interest", "amount"})
    public Debt(ICitizen debitor, ICreditor creditor, DateTime dueDate, double interest, int amount) {
        this.debitor = debitor;
        this.creditor = creditor;
        this.dueDate = dueDate;
        this.interest = interest;
        this.amount = amount;
    }

    @Override
    public ICitizen getDebitor() {
        return this.debitor;
    }

    @Override
    public ICreditor getCreditor() {
        return this.creditor;
    }

    @Override
    public DateTime getDueDate() {
        return this.dueDate;
    }

    @Override
    public double getInterest() {
        return this.interest;
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    public static class DebtBuilder {
        private ICitizen debitor;
        private ICreditor creditor;
        private DateTime dueDate;
        private double interest;
        private int amount;

        DebtBuilder() {
        }

        public DebtBuilder debitor(ICitizen debitor) {
            this.debitor = debitor;
            return this;
        }

        public DebtBuilder creditor(ICreditor creditor) {
            this.creditor = creditor;
            return this;
        }

        public DebtBuilder dueDate(DateTime dueDate) {
            this.dueDate = dueDate;
            return this;
        }

        public DebtBuilder interest(double interest) {
            this.interest = interest;
            return this;
        }

        public DebtBuilder amount(int amount) {
            this.amount = amount;
            return this;
        }

        public Debt build() {
            return new Debt(this.debitor, this.creditor, this.dueDate, this.interest, this.amount);
        }

        public String toString() {
            return "Debt.DebtBuilder(debitor=" + this.debitor + ", creditor=" + this.creditor + ", dueDate=" + this.dueDate + ", interest=" + this.interest + ", amount=" + this.amount + ")";
        }
    }
}

