/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.IMap;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.IUpdateableState;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.IConcurrent;
import ch.sahits.game.openpatrician.model.people.impl.BaseTavernPerson;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
public class ConcurrentState
extends BaseTavernPerson
implements IConcurrent,
IUpdateableState {
    @Autowired
    private Random rnd;
    @Autowired
    private IMap map;
    private IPlayer clientPlayer;
    private IPlayer concurrentPlayer;
    private int premium;

    @Override
    public String getName() {
        return this.clientPlayer.getName() + " " + this.clientPlayer.getLastName();
    }

    @Override
    public String getConcurrentName() {
        return this.concurrentPlayer.getName() + " " + this.concurrentPlayer.getLastName();
    }

    @Override
    public void update() {
        ArrayList<IPlayer> players = new ArrayList<IPlayer>();
        List<ICity> cities = this.map.getCities();
        for (ICity city : cities) {
            List<IPlayer> cityPlayers = city.getResidentPlayers();
            for (IPlayer p : cityPlayers) {
                if (!(p instanceof IAIPlayer)) continue;
                players.add(p);
            }
        }
        IPlayer p1 = (IPlayer)players.remove(this.rnd.nextInt(players.size()));
        IPlayer p2 = (IPlayer)players.remove(this.rnd.nextInt(players.size()));
        this.setClientPlayer(p1);
        this.setConcurrentPlayer(p2);
        this.setPremium(this.rnd.nextInt(8500) + 1500);
    }

    @Override
    public IPlayer getClientPlayer() {
        return this.clientPlayer;
    }

    public void setClientPlayer(IPlayer clientPlayer) {
        this.clientPlayer = clientPlayer;
    }

    @Override
    public IPlayer getConcurrentPlayer() {
        return this.concurrentPlayer;
    }

    public void setConcurrentPlayer(IPlayer concurrentPlayer) {
        this.concurrentPlayer = concurrentPlayer;
    }

    @Override
    public int getPremium() {
        return this.premium;
    }

    public void setPremium(int premium) {
        this.premium = premium;
    }
}

