/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IMap;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.IUpdateableState;
import ch.sahits.game.openpatrician.model.MapSegmentedImage;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.impl.CitiesState;
import ch.sahits.game.openpatrician.model.people.IInformant;
import ch.sahits.game.openpatrician.model.people.ISeaPirate;
import ch.sahits.game.openpatrician.model.people.impl.BaseTavernPerson;
import ch.sahits.game.openpatrician.model.people.impl.SeaPiratesState;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.util.CityUtilities;
import ch.sahits.game.openpatrician.util.GenericPair;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
import com.google.common.base.Optional;
import java.util.Random;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
public class InformantState
extends BaseTavernPerson
implements IInformant,
IUpdateableState {
    @Autowired
    private Random rnd;
    @Autowired
    private SeaPiratesState pirateState;
    @Autowired
    private CitiesState cityState;
    @Autowired
    private CityUtilities cityUtils;
    @Autowired
    private IMap map;
    private int price;
    private String name;
    private Optional<GenericPair<ICity, IWare>> wareNeeded = Optional.absent();
    private Optional<GenericPair<ICity, IWare>> wareSurplus = Optional.absent();
    private Optional<GenericPair<String, ICity>> pirateLocation = Optional.absent();
    private boolean showMapIfAvailable;
    private static RandomNameLoader firstNameLoader = new RandomNameLoader("firstnames.properties");
    private static RandomNameLoader lastNameLoader = new RandomNameLoader("lastnames.properties");

    public InformantState() {
        this.name = firstNameLoader.getRandomName() + " " + lastNameLoader.getRandomName();
    }

    @Override
    public void update() {
        boolean noInformationYet;
        int val = this.rnd.nextInt(2);
        this.showMapIfAvailable = this.rnd.nextInt(3) == 0;
        this.price = this.rnd.nextInt(1000) + 120;
        this.updateWareNeedOrSurplus(val);
        int nextVal = this.rnd.nextInt(2);
        if (val != nextVal) {
            this.updateWareNeedOrSurplus(nextVal);
        }
        boolean bl = noInformationYet = !this.wareNeeded.isPresent() && !this.wareSurplus.isPresent();
        if (this.rnd.nextBoolean() || noInformationYet) {
            ISeaPirate pirate = this.pirateState.findSuccessfulPirate();
            ICity nearest = this.cityUtils.findNearestCity(pirate.getLocation());
            this.setPirateLocation(pirate, nearest);
        }
    }

    @Override
    public int getPrice(IPlayer player) {
        if (this.showMapIfAvailable && player.getSegmentedMap() != null) {
            return this.price + this.rnd.nextInt(1000) + 1000;
        }
        return this.price;
    }

    private void setNeededWare(ICity city, IWare ware) {
        this.wareNeeded = Optional.of((Object)new GenericPair((Object)city, (Object)ware));
    }

    private void setWareSurplus(ICity city, IWare ware) {
        this.wareSurplus = Optional.of((Object)new GenericPair((Object)city, (Object)ware));
    }

    private void setPirateLocation(ISeaPirate pirate, ICity city) {
        this.pirateLocation = Optional.of((Object)new GenericPair((Object)pirate.getName(), (Object)city));
    }

    private void updateWareNeedOrSurplus(int val) {
        switch (val) {
            case 0: {
                Optional<GenericPair<ICity, IWare>> missing = this.cityState.findCityWithMostNeededWare();
                if (!missing.isPresent()) break;
                GenericPair pair = (GenericPair)missing.get();
                this.setNeededWare((ICity)pair.getFirst(), (IWare)pair.getSecond());
                break;
            }
            case 1: {
                Optional<GenericPair<ICity, IWare>> surplus = this.cityState.findCityWithSurplusWare();
                if (!surplus.isPresent()) break;
                GenericPair pair = (GenericPair)surplus.get();
                this.setWareSurplus((ICity)pair.getFirst(), (IWare)pair.getSecond());
                break;
            }
            default: {
                throw new IllegalStateException("Invalid random number: " + val);
            }
        }
    }

    @Override
    public Optional<MapSegmentedImage> getMapSectionPart(IPlayer player) {
        if (player.getSegmentedMap() != null && this.showMapIfAvailable) {
            int index;
            MapSegmentedImage segmentedImage = player.getSegmentedMap();
            do {
                index = this.rnd.nextInt(9);
            } while (segmentedImage.getSegmentIndices().contains(index));
            segmentedImage.addSegment(index);
            return Optional.of((Object)segmentedImage);
        }
        return Optional.absent();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Optional<GenericPair<ICity, IWare>> getWareNeeded() {
        return this.wareNeeded;
    }

    @Override
    public Optional<GenericPair<ICity, IWare>> getWareSurplus() {
        return this.wareSurplus;
    }

    @Override
    public Optional<GenericPair<String, ICity>> getPirateLocation() {
        return this.pirateLocation;
    }
}

