/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IUpdatableCityRelatedState;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.ITransportTrader;
import ch.sahits.game.openpatrician.model.people.impl.BaseTavernPerson;
import ch.sahits.game.openpatrician.model.util.CityUtilities;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
import java.util.ArrayList;
import java.util.Random;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
public class TransportTraderState
extends BaseTavernPerson
implements ITransportTrader,
IUpdatableCityRelatedState {
    @Autowired
    private Random rnd;
    @Autowired
    private CityUtilities cityUtils;
    private String name;
    private ICity destination;
    private int premium;
    private int neededCapacity;
    private static RandomNameLoader firstNameLoader = new RandomNameLoader("firstnames.properties");
    private static RandomNameLoader lastNameLoader = new RandomNameLoader("lastnames.properties");

    @Override
    public void update(ICity currentCity) {
        this.setName(firstNameLoader.getRandomName() + " " + lastNameLoader.getRandomName());
        this.setPremium(this.rnd.nextInt(700) + 300);
        this.setNeededCapacity(this.rnd.nextInt(40) + 4);
        ArrayList<ICity> visited = new ArrayList<ICity>();
        visited.add(currentCity);
        ICity next = this.cityUtils.findNearbyCityRepeated(currentCity, 1.0, 1024, visited);
        this.setDestination(next);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    @Override
    public ICity getDestination() {
        return this.destination;
    }

    private void setDestination(ICity destination) {
        this.destination = destination;
    }

    @Override
    public int getPremium() {
        return this.premium;
    }

    private void setPremium(int premium) {
        this.premium = premium;
    }

    @Override
    public int getNeededCapacity() {
        return this.neededCapacity;
    }

    private void setNeededCapacity(int neededCapacity) {
        this.neededCapacity = neededCapacity;
    }
}

