/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.personal.impl;

import ch.sahits.game.event.data.PeriodicalTimeWeekUpdate;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.LoanGivingEvent;
import ch.sahits.game.openpatrician.model.event.RemitLoanEvent;
import ch.sahits.game.openpatrician.model.factory.PeriodicalTimeUpdateFactory;
import ch.sahits.game.openpatrician.model.people.ReputationCalculator;
import ch.sahits.game.openpatrician.model.personal.IReputation;
import ch.sahits.game.openpatrician.model.time.EUpdateIntervalRegistration;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
public class Reputation
implements IReputation {
    private int reputationLastWeek = 0;
    private int reputationCurrentWeek = 0;
    private final ICity city;
    private final IPlayer player;
    @Autowired
    private ReputationCalculator repCalc;
    @Autowired
    private PeriodicalTimeUpdateFactory timeUpdateFactory;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;

    public Reputation(ICity city, IPlayer player) {
        this.city = city;
        this.player = player;
    }

    private void init() {
        this.clientServerEventBus.register((Object)this);
        this.timeUpdateFactory.createPeriodicalUpdater(EUpdateIntervalRegistration.WEEK);
    }

    @Override
    public int getReputationDifference() {
        return this.reputationCurrentWeek - this.reputationLastWeek;
    }

    @Subscribe
    public void handleWeeklyUpdate(PeriodicalTimeWeekUpdate event) {
        this.reputationLastWeek = this.reputationCurrentWeek;
        this.reputationCurrentWeek = this.repCalc.calculateWareRepputation(this.city, this.player);
    }

    @Override
    public int getPopularity() {
        return this.reputationCurrentWeek;
    }

    @Subscribe
    public void handleLoanGiving(LoanGivingEvent event) {
        if (event.getDebt().getCreditor().equals(this.player) && event.getCity().equals(this.city)) {
            this.reputationCurrentWeek += event.getDebt().getAmount() / 1000 * 10;
        }
    }

    @Subscribe
    public void handleRemitLoan(RemitLoanEvent event) {
        if (event.getDebt().getCreditor().equals(this.player) && event.getCity().equals(this.city)) {
            this.reputationCurrentWeek += 500;
        }
    }
}

