/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.product;

import ch.sahits.game.openpatrician.model.BaseAmountable;
import ch.sahits.game.openpatrician.model.IAmountable;
import javafx.beans.binding.NumberBinding;
import javafx.beans.binding.When;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;

public class AmountablePrice<T extends IAmountable>
extends BaseAmountable<T> {
    private final DoubleProperty sum = new SimpleDoubleProperty((Object)this, "sum", 0.0);

    public int getAVGPrice() {
        return (int)Math.rint(this.sum.doubleValue() / (double)this.amount.get());
    }

    public NumberBinding avgPriceProperty() {
        return new When((ObservableBooleanValue)this.sum.isEqualTo(0).or((ObservableBooleanValue)this.amount.isEqualTo(0))).then(0).otherwise((ObservableNumberValue)this.sum.divide((ObservableNumberValue)this.amount));
    }

    public void add(int amount, int avgPrice) {
        if (amount < 0) {
            amount = Math.abs(amount);
        }
        int current = this.amount.get();
        this.amount.set(current + amount);
        long sum = this.sum.longValue();
        this.sum.set((double)(sum + (long)(amount * avgPrice)));
    }

    @Override
    public void remove(int amount) {
        if (amount < 0) {
            amount = Math.abs(amount);
        }
        if (amount == Integer.MIN_VALUE) {
            amount = Integer.MAX_VALUE;
        }
        if (this.amount.get() < amount) {
            this.amount.set(0);
            this.sum.set(0.0);
        } else {
            long sum = this.sum.longValue();
            this.sum.set((double)(sum - (long)(amount * this.getAVGPrice())));
            int current = this.amount.get();
            this.amount.set(current - amount);
        }
        if (this.amount.get() == 0) {
            this.sum.set(0.0);
        }
    }

    @Override
    public void reset() {
        this.sum.set(0.0);
        super.reset();
    }

    @Override
    public String toString() {
        return this.amount.get() + "@" + this.getAVGPrice();
    }
}

