/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.product;

import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.IWare;
import com.google.common.annotations.VisibleForTesting;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;

@LazySingleton
public class WareAmountCalculator {
    public int calculateBuyAmount(IWare ware, ICity city, int avgPrice) {
        return this.calculateAmount(ware, city, avgPrice, true);
    }

    public int calculateSellAmount(IWare ware, ICity city, int avgPrice) {
        return this.calculateAmount(ware, city, avgPrice, false);
    }

    private int calculateAmount(IWare ware, ICity city, int avgPrice, boolean buying) {
        SimpleIntegerProperty availableAmount = new SimpleIntegerProperty(city.getWare(ware).getAmount());
        int amount = 100;
        int price = this.calculateAvgPrice(ware, (IntegerProperty)availableAmount, amount, buying);
        while (price < avgPrice) {
            price = this.calculateAvgPrice(ware, (IntegerProperty)availableAmount, amount += 100, buying);
        }
        if (price == avgPrice) {
            return amount;
        }
        int upperLimit = amount;
        int lowerLimit = amount - 100;
        return this.searchAvgPrice(ware, (IntegerProperty)availableAmount, avgPrice, lowerLimit, upperLimit, buying);
    }

    @VisibleForTesting
    int searchAvgPrice(IWare ware, IntegerProperty availableAmount, int avgPrice, int lowerAmount, int upperAmount, boolean buying) {
        if (lowerAmount == upperAmount - 1) {
            return lowerAmount;
        }
        int amount = upperAmount - (upperAmount - lowerAmount) / 2;
        int price = this.calculateAvgPrice(ware, availableAmount, amount, buying);
        if (price == avgPrice) {
            return amount;
        }
        if (price > avgPrice) {
            return this.searchAvgPrice(ware, availableAmount, avgPrice, lowerAmount, amount, buying);
        }
        return this.searchAvgPrice(ware, availableAmount, avgPrice, amount, upperAmount, buying);
    }

    private int calculateAvgPrice(IWare ware, IntegerProperty availableAmount, final int amount, boolean buying) {
        IntegerBinding buyAmount = new IntegerBinding(){

            protected int computeValue() {
                return amount;
            }
        };
        if (buying) {
            return ware.buyPrice(availableAmount, buyAmount);
        }
        return ware.sellPrice(availableAmount, buyAmount);
    }
}

