/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.ship;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.people.IPerson;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.IShipWeaponsLocation;
import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import com.google.common.base.Optional;
import java.util.Set;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.IntegerProperty;
import javafx.geometry.Point2D;

public interface IShip {
    public int getSize();

    public int getCapacity();

    public boolean isUpgradable();

    public void upgrade();

    public String getName();

    public void setName(String var1);

    public Set<IWare> getLoadedWares();

    public int load(IWare var1, int var2, int var3);

    public int unload(IWare var1, int var2);

    public int getDamage();

    public void damage(Object var1);

    public void repair();

    public int getUpgradeSpaceReduction();

    @Deprecated
    public int getLoad();

    public IntegerBinding getLoadBinding();

    public AmountablePrice<IWare> getWare(IWare var1);

    public boolean hasWeapons();

    public int getValue();

    public int getNumberOfSailors();

    public void setNumberOfSailors(int var1);

    public IntegerProperty numberOfSailorsProperty();

    public int getMinNumberOfSailors();

    public int getMaxNumberOfSailors();

    public Optional<ICaptain> getCaptian();

    public void setCaptain(ICaptain var1);

    public void move(IWeapon var1, int var2);

    public int getWeaponAmount(IWeapon var1);

    public void addPassenger(IPerson var1);

    public void leavePassanger();

    public Optional<IPerson> getPassenger();

    public Point2D getLocation();

    public void setLocation(Point2D var1);

    public IPlayer getOwner();

    public boolean isPiratingShip();

    public EShipType getShipType();

    public void setOwner(IPlayer var1);

    public EShipUpgrade getShipUpgradeLevel();

    public IShipWeaponsLocation getShipWeaponsLocation();

    public boolean isAvailable();

    public void setAvailable(boolean var1);

    public int getOccupiedSpace();

    public void setOccupiedSpace(int var1);
}

