/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.util;

import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.model.IMap;
import ch.sahits.game.openpatrician.model.city.ICity;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javafx.geometry.Point2D;
import org.springframework.beans.factory.annotation.Autowired;

@LazySingleton
public class CityUtilities {
    @Autowired
    private IMap map;
    @Autowired
    private Random rnd;
    private final Range<Double> range = Range.openClosed((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0));

    public Optional<ICity> findNearbyCity(ICity startCity, double radiusFactor, int max, List<ICity> exclude) {
        List<ICity> cities = this.map.getCities();
        Preconditions.checkArgument((boolean)this.range.contains((Comparable)Double.valueOf(radiusFactor)), (Object)"Range factor must be in (0,1]");
        double radius = (double)max * radiusFactor;
        LinkedList<ICity> copy = new LinkedList<ICity>(cities);
        Collections.shuffle(copy);
        Point2D p1 = startCity.getCoordinates();
        for (ICity city : copy) {
            Point2D p2;
            double dist;
            if (exclude.contains(city) || city.equals(startCity) || !((dist = this.calculateDistance(p1, p2 = city.getCoordinates())) <= radius)) continue;
            return Optional.of((Object)city);
        }
        return Optional.absent();
    }

    public ICity findNearbyCityRepeated(ICity startCity, double radiusFactor, int max, List<ICity> exclude) {
        Preconditions.checkArgument((boolean)this.checkCities(startCity, exclude), (Object)"No city is choosable");
        Optional<ICity> result = this.findNearbyCity(startCity, radiusFactor, max, exclude);
        while (!result.isPresent()) {
            result = this.findNearbyCity(startCity, radiusFactor *= 1.01, max, exclude);
        }
        return (ICity)result.get();
    }

    private boolean checkCities(ICity startCity, List<ICity> exclude) {
        List<ICity> cities = this.map.getCities();
        for (ICity city : cities) {
            if (city.equals(startCity) || exclude.contains(city)) continue;
            return true;
        }
        return false;
    }

    public ICity findNearestCity(Point2D p) {
        List<ICity> cities = this.map.getCities();
        ICity nearest = cities.get(0);
        double dist = this.calculateDistance(p, nearest.getCoordinates());
        for (int i = 1; i < cities.size(); ++i) {
            ICity city = cities.get(i);
            double d = this.calculateDistance(p, city.getCoordinates());
            if (!(d < dist)) continue;
            dist = d;
            nearest = city;
        }
        return nearest;
    }

    public ICity findRandomCity(ICity excludedCity) {
        ArrayList cities = Lists.newArrayList(this.map.getCities());
        cities.remove(excludedCity);
        int index = this.rnd.nextInt(cities.size());
        return (ICity)cities.get(index);
    }

    private double calculateDistance(Point2D p1, Point2D p2) {
        double diffX = p1.getX() - p2.getX();
        double diffY = p1.getY() - p2.getY();
        return Math.sqrt(diffX * diffX + diffY * diffY);
    }
}

