/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.util;

import ch.sahits.game.openpatrician.model.personal.EEconomicCareer;
import ch.sahits.game.openpatrician.model.personal.EMilitantCareer;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.personal.ICareer;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;

@Service
public class ModelTranslations {
    @Autowired
    private Locale locale;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messages;

    public String getLocalDisplayName(EWeapon weapon) {
        return this.messages.getMessage(weapon.name(), new Object[0], this.locale.getCurrentLocal());
    }

    public String getLocalDisplayName(EWare ware) {
        return this.messages.getMessage(ware.getWareID(), new Object[0], this.locale.getCurrentLocal());
    }

    public String getLocalDisplayName(ICareer career) {
        if (career instanceof EEconomicCareer) {
            return this.messages.getMessage(((EEconomicCareer)career).name(), new Object[0], this.locale.getCurrentLocal());
        }
        if (career instanceof EMilitantCareer) {
            return this.messages.getMessage(((EMilitantCareer)career).name(), new Object[0], this.locale.getCurrentLocal());
        }
        throw new IllegalArgumentException("Unknown career implementation: " + career.getClass().getName());
    }

    public String getLocalDisplayName(ESocialRank rank) {
        return this.messages.getMessage(rank.name(), new Object[0], this.locale.getCurrentLocal());
    }
}

