package ch.sahits.game.openpatrician.model;

import ch.sahits.game.openpatrician.dialog.DialogTemplate;
import lombok.Getter;
import lombok.Setter;

/**
 * Message that can be displayed on screen. The message contents is formatted with markup.
 * A short message is displayed as a notification. The message will be displayed in the notice
 * board.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Feb 18, 2013
 *
 */
public final class DisplayMessage {
    @Getter
	private final String message;
    @Getter
    @Setter
	private String shortMessage;
	@Getter
	@Setter
	private DialogTemplate dialogTemplate;

	public DisplayMessage(String message, String shortMessage) {
		this(message);
		this.shortMessage = shortMessage;
	}
	public DisplayMessage(String message) {
		super();
		this.message = message;
	}
	public DisplayMessage(String message, DialogTemplate template) {
		this(message);
		this.dialogTemplate = template;
	}

    /**
     * Check whether there is a short message.
     * @return true if the short message is available
     */
	public boolean hasShortMessage() {
		return shortMessage != null;
	}

	/**
	 * Check wether a dialog template is set.
	 * @return
	 */
	public boolean hasDialogTemplate() {
		return dialogTemplate != null;
	}
}
