package ch.sahits.game.openpatrician.model;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.ICreditor;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 30, 2014
 */
public interface ICitizen extends ICreditor {
	/**
	 * Retrieve the players name
	 * @return
	 */
	String getName();

	/**
	 * Get a players last name
	 * @return
	 */
	String getLastName();

	/**
	 * Retrieve the social rank of the player
	 * @return
	 */
	ESocialRank getRank();

	/**
	 * Retreive the hometown of the citizen.
	 * @return
	 */
	ICity getHometown();
}
