package ch.sahits.game.openpatrician.model;

/**
 * Model of the game.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Sep 9, 2011
 *
 */
public interface IGame {
	/**
	 * Retrieve the map
	 * @return
	 */
	public IMap getMap();
	/**
	 * check if the objective of the game is reached. This method may not be called by the server part
	 * @return
	 */
	public boolean isObjectivReached();
	/**
	 * Set a new game speed
	 * @param speed
	 */
	public void setGameSpeed(EGameSpeed speed);
	/**
	 * Retrieve the current game speed
	 * @return
	 */
	public EGameSpeed getGameSpeed();
	/**
	 * Retrieve the difficultiy level of the game
	 * @return
	 */
	public Difficulty getDifficulty();
	/**
	 * Retrieve the game time
	 * @return
	 */
	public Date getTime();

	/**
	 * Switch to fast forward until the first interuption.
	 */
	void fastForward();
}
