package ch.sahits.game.openpatrician.model;

import ch.sahits.game.openpatrician.model.city.ICity;
import javafx.geometry.Dimension2D;

import java.util.List;


/**
 * Interface defining the map that defines the game plan
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Sep 9, 2011
 *
 */
public interface IMap {
	/**
	 * Retrieve the number of cities that are on the map.
	 * @return
	 */
	int getNumberCities();
	/**
	 * Retrieve an unmodifiable list of all the cities in the map
	 * @return
	 */
	List<ICity> getCities();
	// TODO need more specific methods to find a city

    /**
     * Retrieve the map dimensions
     * @return dimesion
     */
    Dimension2D getDimension();

    /**
     * Retrieve the path for the map image without the cities added.
     * @return
     */
    String getMapImagePath();

}
