package ch.sahits.game.openpatrician.model;

import lombok.Getter;

import java.util.TreeSet;

/**
 * Model of a map segment which is split up and not all parts may be available.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Nov 13, 2014
 */
public class MapSegmentedImage {
    @Getter
    private final String imageName;
    @Getter
    private final TreeSet<Integer> segmentIndices;

    public MapSegmentedImage(String imageName) {
        this.imageName = imageName;
        segmentIndices = new TreeSet<>();
    }

    public void addSegment(int index) {
        segmentIndices.add(index);
    }
}
