package ch.sahits.game.openpatrician.model.building;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import ch.sahits.game.openpatrician.model.building.ETradeType;
import ch.sahits.game.openpatrician.model.product.IWare;

/**
 * Interface defining the automated trading done by the steward between the city and the office
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 22, 2012
 *
 */
public interface IAutomatedTrading {
	/**
	 * Retrieve the  minimal amount of the ware that should be hold in the
	 * storage.
	 * @param ware to be hold
	 * @return amount of that ware
	 */
	public int getAmount(IWare ware);
	/**
	 * Retrieve the price up to which the ware is bought or the minimal price for which it is sold.
	 * @param ware to be bought or sold
	 * @return price
	 */
	public int getPrice(IWare ware);
	/**
	 * Retrieve the trading type of the ware. There are only three types applicable:
	 * NONE, OFFICE_CITY and CITY_OFFICE
	 * @param ware 
	 * @return
	 */
	public ObjectProperty<ETradeType> tradingTypeProperty(IWare ware);
	/**
	 * Check if this ware can be moved onto ships with automated trading routes
	 * @param ware
	 * @return
	 */
	public boolean isMovableToShip(IWare ware);
	/**
	 * Update the amount of ware
	 * @param ware to be updated
	 * @param difference in the amount
	 */
	public void updateAmount(IWare ware,int difference);
	/**
	 * Update the price of the ware
	 * @param ware to be updated
	 * @param difference in the price
	 */
	public void updatePrice(IWare ware, int difference);
	/**
	 * Set the Trayding type. Only allowed types are  
	 * NONE, OFFICE_CITY and CITY_OFFICE
	 * @param ware to be updated
	 * @param tt
	 */
	public void setTradingType(IWare ware, ETradeType tt);
	/**
	 * Set the movable flag
	 * @param ware to be updated
	 * @param isMovable
	 */
	public void setMovableToShip(IWare ware, boolean isMovable);
	/**
	 * Get to the amount property of the tradeable ware.
	 * @param ware
	 * @return
	 */
	public IntegerProperty amountProperty(IWare ware);
	/**
	 * Get the price property of the tradable ware.
	 * @param ware
	 * @return
	 */
	IntegerProperty priceProperty(IWare ware);
	/**
	 * Get the movable to ship flag.
	 * @param ware
	 * @return
	 */
	BooleanProperty movableToShipProperty(IWare ware);
}
