package ch.sahits.game.openpatrician.model.building.impl;

import ch.sahits.game.openpatrician.model.building.ISteward;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import lombok.Getter;

public class Steward implements ISteward {
	// TODO periodically increase the expertice level and the salery
	@Getter
	private int expertiseLevel;
    @Getter
	private int salary;

	private IntegerProperty totalProfit;
	

	public Steward() {
		this.expertiseLevel = 0;
		this.salary = 5;
		this.totalProfit = new SimpleIntegerProperty(0);
		totalProfit.addListener(new ChangeListener<Number>() {
			@Override
			public void changed(ObservableValue<? extends Number> observableValue, Number oldProfit, Number newProfit) {
				if (newProfit.intValue() >= 10000 + (expertiseLevel*10000)) {
					// level up
					expertiseLevel++;
					totalProfit.setValue(0);
				}
			}
		});
	}

	@Override
	public int getTotalProfitOnExperianceLevel() {
		return totalProfit.get();
	}

	@Override
	public void updateProfit(int profit) {
		totalProfit.setValue(totalProfit.get() + profit);
	}

	@Override
	public double getDiscountFactor() {
		return 0.95 - (0.05*expertiseLevel);
	}

}
