package ch.sahits.game.openpatrician.model.city;

import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.util.PropertyLoader;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/**
 * This class provides numbers for production rates. The rates are what is produced in a week and the
 * size is specific to the ware. This class is intended before release 2.0
 * with a real implementation of the workshops in the city instead of this mock up.
 * This implementation does not consume any wares to produce the product.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Nov 28, 2011
 *
 */
@Service
public class CityProduction {
	/*
	 * This implementation should be replaced by a list of workshops owned by the city
	 * and allow the city controller to build new workshops.
	 * This would take care of the production rates as well as the consumed wares.
	 */
	private Map<IWare, Integer> productionRates = new HashMap<IWare, Integer>();
	
	public CityProduction() {
		Properties props = PropertyLoader.loadProperties("productionrates.properties");
		EWare[] wares = EWare.values();
		for (EWare ware : wares) {
			productionRates.put(ware, Integer.parseInt(props.getProperty(ware.name())));
		}
	}
	
	/**
	 * Compute the amount of <code>ware</code> that is produced efficiently within a week
	 * @param ware
	 * @return
	 */
	public int getEfficientProduction(IWare ware){
		return productionRates.get(ware);
	}
	
	/**
	 * Compute the amount of <code>ware</code> that is produced inefficiently within a week
	 * @param ware
	 * @return
	 */
	public int getInefficientProduction(IWare ware){
		return productionRates.get(ware)/2;
	}
}
