package ch.sahits.game.openpatrician.model.city.cityhall.impl;

import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityGuard;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityHall;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityHallNotice;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityPetition;
import ch.sahits.game.openpatrician.model.city.cityhall.IEldermanOffice;
import ch.sahits.game.openpatrician.model.city.cityhall.ITreasury;
import ch.sahits.game.openpatrician.model.ship.IShip;
import com.google.common.base.Optional;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import org.joda.time.DateTime;

import java.util.List;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 31, 2014
 */
@RequiredArgsConstructor
public class CityHall implements ICityHall {
    @Getter
    private final List<ICityHallNotice> notices;
    @Getter
    @Setter
    private Optional<IShip> outrigger;
    @Getter
    @Setter
    private ICitizen mayor;
    @Getter
    private DateTime electionDate;
    @Getter
    private final List<ICitizen> candidates;
    @Getter
    @Setter
    private Optional<DateTime> nextCouncilMeeting;
    @Getter
    @Setter
    private Optional<ICityPetition> petition;
    @Getter
    @Setter
    private ICitizen elderman;
    @Getter
    @Setter
    private DateTime eldermanElectionDate;
    @Getter
    private final List<ICitizen> eldermanCandidates;
    @Getter
    private final ITreasury treasury;
    @Getter
    private final List<ICityGuard> cityGuard;
    @Getter
    @Setter
    private Optional<IEldermanOffice> eldermanOffice;

    @Override
    public void updateDaily() {
        // todo: andi 12/31/14: implement
    }

    @Override
    public void updateWeekly() {
        // todo: andi 12/31/14: implement
    }

    @Override
    public void updateMonthly() {
        // todo: andi 12/31/14: implement
    }

    @Override
    public void updateEndOfYear() {
        // todo: andi 12/31/14: implement
    }
}
