package ch.sahits.game.openpatrician.model.city.cityhall.impl;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityHallNotice;
import ch.sahits.game.openpatrician.model.city.cityhall.IPikemen;
import ch.sahits.game.openpatrician.model.people.IContractBroker;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;
import lombok.Getter;
import lombok.experimental.Builder;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 31, 2014
 */
public class Pikemen extends CityGuard implements IPikemen {
    /**
     * @author Andi Hotz, (c) Sahits GmbH, 2014
     *         Created on Dec 31, 2014
     */
    @Builder
    public static class CityHallNotice implements ICityHallNotice {
        @Getter
        private final IContractBroker contact;
        @Getter
        private final IWare requiredWare;
        @Getter
        private final ICity destination;
        @Getter
        private final AmountablePrice<IWare> wareAndAmount;


    }
}
