package ch.sahits.game.openpatrician.model.city.cityhall.impl;

import ch.sahits.game.openpatrician.model.city.cityhall.ITreasury;
import lombok.Getter;
import lombok.experimental.Builder;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 31, 2014
 */
@Builder
public class Tresury implements ITreasury {
    @Getter
    private double currentHeadTaxValue = 4;
    @Getter
    private double currentPropertyTax = 280;
    @Getter
    private long paidTaxes = 0;
    @Getter
    private long paidSpecialTaxes = 0;
    @Getter
    private int cityGuardCosts = 0;
    @Getter
    private int buildingCosts = 0;
    @Getter
    private int outriggerCosts = 0;
    @Getter
    private int siegeCosts = 0;
    @Getter
    private int otherCosts = 0;
    @Getter
    private int otherIncome = 0;

    public void update(long cash) {
       if (cash < 0) {
           otherCosts -= cash;
       } else {
           otherIncome += cash;
       }
    }
}
