package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.city.ICreditor;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.experimental.Builder;
import org.joda.time.DateTime;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 30, 2014
 */
@RequiredArgsConstructor
@Builder
public class Debt implements IDebt {
    @Getter
    private final ICitizen debitor;
    @Getter
    private final ICreditor creditor;
    @Getter
    private final DateTime dueDate;
    @Getter
    private final double interest;
    @Getter
    private final int amount;
}
