package ch.sahits.game.openpatrician.model.factory;

import ch.sahits.game.openpatrician.model.time.EUpdateIntervalRegistration;
import ch.sahits.game.openpatrician.model.time.PeriodicalTimeUpdaterV2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

/**
 * Factory for crating PeriodicalTimeUpdateFactoryV2 instances.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Nov 30, 2014
 */
@Service
public class PeriodicalTimeUpdateFactory {
    @Autowired
    private ApplicationContext context;
    public PeriodicalTimeUpdaterV2 createPeriodicalUpdater(EUpdateIntervalRegistration intervall) {
        switch (intervall) {
            case END_OF_DAY:
                return (PeriodicalTimeUpdaterV2) context.getBean("periodicalEndOfDayUpdater"); // singleton instance
            default:
                return (PeriodicalTimeUpdaterV2) context.getBean("periodicalUpdater", new Object[]{intervall});
        }
    }
}
