package ch.sahits.game.openpatrician.model.impl;

import ch.sahits.game.openpatrician.model.GameFactory;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.personal.impl.PersonalData;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
import org.joda.time.DateTime;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/**
 * Implementation of an artificial intelligence player.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Sep 17, 2011
 *
 */
@Component("aiPlayer")
@Scope("prototype")
public class AIPlayer extends Player implements IAIPlayer {

	private static RandomNameLoader firstNameLoader = new RandomNameLoader("firstnames.properties");
	private static RandomNameLoader lastNameLoader = new RandomNameLoader("lastnames.properties");

	public AIPlayer(ICity homeTown,long cash, DateTime birthDate, GameFactory gameFactory) {
		super(homeTown, getPersonalData(homeTown, birthDate),cash,ESocialRank.BARGAINER, gameFactory);
	}

	private static PersonalData getPersonalData(ICity homeTown, DateTime birthDate) {
		return new PersonalData(getRandomFirstName(), getRandomLastName(), true, homeTown, birthDate);
	}

	private static String getRandomFirstName(){
		return firstNameLoader.getRandomName();
	}
	private static String getRandomLastName(){
		return lastNameLoader.getRandomName();
	}
}
