package ch.sahits.game.openpatrician.model.impl;

import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IMap;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.impl.CaptainsState;
import javafx.geometry.Dimension2D;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
/**
 * Implementation of the game map.
 * This singleton is instaniated by the Game Factory.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Sep 16, 2011
 *
 */
@Lazy
@Component
public class GameMap implements IMap {
	@Autowired
    @Setter
	private CaptainsState captainsState;

	private final LinkedList<ICity> cities = new LinkedList<>();
    @Getter
    private Dimension2D dimension;
    @Getter
    private String mapImagePath;

    /**
     * Initialize the map by means of a list of its cities.
     * @param cities
     */
    public void setup(Date date, Collection<ICity> cities, Dimension2D dim, String mapName) {
        dimension = dim;
        mapImagePath = mapName;
        for (ICity city : cities) {
            this.cities.add(city);
        }
        captainsState.init(this);
    }
	@Override
	public int getNumberCities() {
		return cities.size();
	}

	@Override
	public List<ICity> getCities() {
		return Collections.unmodifiableList(cities);
	}
}
