package ch.sahits.game.openpatrician.model.people;

/**
 * Interface describing a captain
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 19, 2013
 *
 */
public interface ICaptain extends IPerson{
	/**
	 * Current age of the captain
	 * @return
	 */
	int getAge();
	/**
	 * Retrieve the name of the captain
	 * @return
	 */
	String getName();
	/**
	 * Retrieve the salary
	 * @return
	 */
	int getSalary();
	/**
	 * Retrieve the level in trading between [0,5]
	 * @return
	 */
	int getTradingSkillLevel();
	/**
	 * Retrieve the level in navigation between [0,5]
	 * @return
	 */
	int getNavigationSkillLevel();
	/**
	 * Retrieve the level in sea fights between [0,5]
	 * @return
	 */
	int getFightSkillLevel();
}
