package ch.sahits.game.openpatrician.model.people;


import javafx.geometry.Point2D;
import ch.sahits.game.openpatrician.model.ship.IShip;


/**
 * Pirate roaming the sea.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 29, 2013
 *
 */
public interface ISeaPirate {
	/**
	 * Get the name of the pirate.
	 * @return
	 */
	String getName();
	/**
	 * Current location of the pirate
	 * @return
	 */
	Point2D getLocation();
	/**
	 * Retrieve the priate's vehicle.
	 * @return
	 */
	IShip getShip();
	/**
	 * Retrieve the number of successful raids.
	 * @return
	 */
	int getNumberOfKills();
}
