package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IMap;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.people.PeopleFactory;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.Iterator;
import java.util.List;
import java.util.Random;

/**
 * Containing the states of the captains
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Feb 2, 2013
 *
 */
@Component
public class CaptainsState {
	@Autowired
	private Random rnd;

	@Value("${freeCaptain.max}")
	private int maxFreeCaptains;
	@Value("${freeCaptain.timeInTown}")
	private int maxTimeInTown;
	@Autowired
	private PeopleFactory peopleFactory;

	private IMap map;

	@Autowired
	private Date date;

	private List<CaptainTownMapping> captainMapping;

	public CaptainsState() {
		captainMapping = Lists.newArrayList();
	}

	/**
	 * The initialisation can only happen after the map is properly initialized,
	 * which only happens on game start.
	 * @param map
	 */
	public void init(IMap map) {
		this.map = map;
		for (int i = 0; i<maxFreeCaptains; i++) {
			// select town
			ICity city = getRandomCity(); // TODO aho Jan 19, 2013: make sure no city is selected twice
			// create arival date in intervall [now-maxTimeInTown,now]
			DateTime currentDate = date.getCurrentDate();
			double nextGaussian = rnd.nextDouble();
			DateTime arrival = currentDate.minus((int)Math.rint(nextGaussian*maxTimeInTown));
			// create captain
			ICaptain captain = peopleFactory.createNewCaptainProperty();
			captainMapping.add(new CaptainTownMapping(city, arrival, captain));
		}
	}

	private ICity getRandomCity() {
		List<ICity> cities = map.getCities();
		return cities.get(rnd.nextInt(cities.size()));
	}

    /**
	 * Return a captain for a town if there is one.
	 * @param city
	 * @return
	 */
	public Optional<ICaptain> getCaptain(ICity city) {
		for (CaptainTownMapping mapped : captainMapping) {
			if (mapped.getTown().equals(city)) {
				return Optional.of(mapped.getCaptain());
			}
		}
		return Optional.absent();
	}
	/**
	 * Remove the captain from the availables.
	 * @param captain
	 * @param city
	 */
	public void hireCaptain(ICaptain captain, ICity city) {
		for (Iterator<CaptainTownMapping> iterator = captainMapping.iterator(); iterator.hasNext();) {
			CaptainTownMapping mapped = iterator.next();
			if (mapped.getTown().equals(city) && mapped.getCaptain().equals(captain)) {
				iterator.remove();
				break;
			}
		}
	}

}
