package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.IMap;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.IUpdateableState;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.IConcurrent;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/**
 * Implementation of a concurrent. Every city can have a concurrent and is referenced
 * through it's TavernEngine.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 20, 2013
 *
 */
@Prototype
public class ConcurrentState extends BaseTavernPerson implements IConcurrent, IUpdateableState {

	@Autowired
	private Random rnd;
	@Autowired
	private IMap map;
    @Getter
    @Setter
	private IPlayer clientPlayer;
    @Getter
    @Setter
	private IPlayer concurrentPlayer;
    @Getter
    @Setter
	private int premium;

	@Override
	public String getName() {
		return clientPlayer.getName()+" "+clientPlayer.getLastName();
	}
	@Override
	public String getConcurrentName() {
		return concurrentPlayer.getName()+" "+concurrentPlayer.getLastName();
	}


	/**
	 * Update the concurrent with a new pair and premium.
	 */
	@Override
	public void update() {
		ArrayList<IPlayer> players = new ArrayList<IPlayer>();
		List<ICity> cities = map.getCities();
		for (ICity city : cities) {
			List<IPlayer> cityPlayers = city.getResidentPlayers();
			for (IPlayer p : cityPlayers) {
				if (p instanceof IAIPlayer) {
					players.add(p);
				}
			}
		}
		IPlayer p1 = players.remove(rnd.nextInt(players.size()));
		IPlayer p2 = players.remove(rnd.nextInt(players.size()));
		setClientPlayer(p1);
		setConcurrentPlayer(p2);
		setPremium(rnd.nextInt(8500)+1500);
	}

}
