package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IMapSection;
import ch.sahits.game.openpatrician.model.IUpdateableState;
import ch.sahits.game.openpatrician.model.people.IPirateHunter;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Random;

/**
 * Implementation of a pirate hunter. Every city can have a pirate hunter and is referenced
 * through it's TavernEngine.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 20, 2013
 *
 */
@Prototype
public class PirateHunterState extends BaseTavernPerson implements IPirateHunter, IUpdateableState {
	@Autowired
	private Random rnd;
    @Getter
    @Setter
	private String clientName;
    @Getter
    @Setter
	private String pirateName;
    @Getter
    @Setter
	private int premium;
	/*
	 * Use custom names
	 * Use different name sources for client and pirate
	 */
	private static RandomNameLoader firstNameLoader = new RandomNameLoader("firstnames.properties");
	private static RandomNameLoader lastNameLoader = new RandomNameLoader("lastnames.properties");


	/**
	 * Update the pirate hunter.
	 */
	@Override
	public void update() {
		setClientName(firstNameLoader.getRandomName()+" "+lastNameLoader.getRandomName());
		setPirateName(firstNameLoader.getRandomName()+" "+lastNameLoader.getRandomName());
		setPremium(rnd.nextInt(5000)+1434);
	}

}
