package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IMap;
import ch.sahits.game.openpatrician.model.IUpdatableCityRelatedState;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.ISmuggler;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.Random;

/**
 * Implementation of a smuggler. Every city can have a smuggler and is referenced
 * through it's TavernEngine.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 20, 2013
 *
 */
@Prototype
public class SmugglerState extends BaseTavernPerson implements ISmuggler, IUpdatableCityRelatedState {
	@Autowired
	private Random rnd;
	@Autowired
	private IMap map;
    @Getter
    @Setter(AccessLevel.PRIVATE)
	private int amount;
    @Getter
    @Setter(AccessLevel.PRIVATE)
	private int premium;
    @Getter
    @Setter(AccessLevel.PRIVATE)
	private ICity destination;

	@Override
	public void update(ICity startCity) {
		setAmount(rnd.nextInt(200)+16);
		setPremium(rnd.nextInt(1000)+180);
		List<ICity> cities = map.getCities();
		ICity nextCity = cities.get(rnd.nextInt(cities.size()));
		while (nextCity.equals(startCity)) {
			nextCity = cities.get(rnd.nextInt(cities.size()));
		}
		setDestination(nextCity);
	}


}
