package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IUpdateableState;
import ch.sahits.game.openpatrician.model.people.IPirate;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
import lombok.Getter;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Random;

/**
 * Implementation of a pirate. Every city can have a pirate and is referenced
 * through it's TavernEngine.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 20, 2013
 *
 */
@Prototype
public class TavernPirateState extends BaseTavernPerson implements IPirate, IUpdateableState {
	@Autowired
	private Random rnd;
    @Getter
	private int followers;
    @Getter
	private String name;
    @Getter
	private double profitShare;

	/*
	 * TODO use pirate names
	 */
	private static RandomNameLoader firstNameLoader = new RandomNameLoader("firstnames.properties");
	private static RandomNameLoader lastNameLoader = new RandomNameLoader("lastnames.properties");


	/**
	 * Update the pirate to become some other physical person.
	 * This entails change of name. The followers and promised
	 * profit share may change as well.
	 */
	@Override
	public void update() {
		name = firstNameLoader.getRandomName()+" "+lastNameLoader.getRandomName();
		followers = rnd.nextInt(15)+12;
        profitShare = (rnd.nextInt(7)*5+35)/100.0;
	}

}
