package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IMapSectionPart;
import ch.sahits.game.openpatrician.model.IUpdateableState;
import ch.sahits.game.openpatrician.model.people.ITreasureMapOwner;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Random;

/**
 * Implementation of a treasure map owner. Every city can have a treasure map owner and is referenced
 * through it's TavernEngine.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 20, 2013
 *
 */
@Prototype
public class TreasureMapOwnerState extends BaseTavernPerson implements
ITreasureMapOwner, IUpdateableState {
	@Autowired
	private Random rnd;
	/*
	 * Use custom names
	 */
	private static RandomNameLoader firstNameLoader = new RandomNameLoader("firstnames.properties");
	private static RandomNameLoader lastNameLoader = new RandomNameLoader("lastnames.properties");

    @Getter
    @Setter(AccessLevel.PRIVATE)
    private String name;
    @Getter
    @Setter(AccessLevel.PRIVATE)
    private int price;


	@Override
	public void update() {
		setName(firstNameLoader.getRandomName()+" "+lastNameLoader.getRandomName());
		setPrice(rnd.nextInt(1500)+1000);
	}

}
