package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IUpdateableState;
import ch.sahits.game.openpatrician.model.people.IWarehouseTenant;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Random;

/**
 * Implementation of a warehouse tenant. Every city can have a warehouse tenant and is referenced
 * through it's TavernEngine.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 20, 2013
 *
 */
@Prototype
public class WarehouseTenant extends BaseTavernPerson implements
IWarehouseTenant, IUpdateableState {
	@Autowired
	private Random rnd;
	/*
	 * Use custom names
	 */
	private static RandomNameLoader firstNameLoader = new RandomNameLoader("firstnames.properties");
	private static RandomNameLoader lastNameLoader = new RandomNameLoader("lastnames.properties");

    @Getter
    @Setter(AccessLevel.PRIVATE)
    private String name;
    @Getter
    @Setter(AccessLevel.PRIVATE)
    private int amount;


	@Override
	public int getRentPerWeek() {
		return 5*amount;
	}
	/**
	 * Update the state.
	 */
	@Override
	public void update() {
		setName(firstNameLoader.getRandomName()+" "+lastNameLoader.getRandomName());
		setAmount(rnd.nextInt(800)+100);
	}
}
