package ch.sahits.game.openpatrician.model.personal.impl;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.personal.ISpouseData;
import javafx.scene.image.Image;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import org.joda.time.DateTime;

@Getter
@EqualsAndHashCode
public class SpouseData extends PersonalData implements ISpouseData {

	private final int popularityInHerHomeTown;
	private final int popularityInYourHomeTown;
	private final int connectionsInHerHomeTown;
	private final int connectionsInYourHomeTown;
	private final Image portrait;
	private int numberOfChildren;

    public SpouseData(String name, String lastName, boolean male,
                      ICity birthplace, DateTime birthDate, int popHer, int popYour,
                      int conHer, int conYour, Image portrait) {
        super(name, lastName, male, birthplace, birthDate);
        this.popularityInHerHomeTown = popHer;
        this.popularityInYourHomeTown = popYour;
        this.connectionsInHerHomeTown = conHer;
        this.connectionsInYourHomeTown = conYour;
        this.portrait = portrait;
        numberOfChildren = 0;
    }

	@Override
	public void newChild(){
        numberOfChildren++;
	}

}
