package ch.sahits.game.openpatrician.model.util;

import ch.sahits.game.openpatrician.model.personal.EEconomicCareer;
import ch.sahits.game.openpatrician.model.personal.EMilitantCareer;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.personal.ICareer;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Nov 26, 2014
 */
@Service
public class ModelTranslations {
    @Autowired
    private Locale locale;
    @Autowired
    @Qualifier("messageSource")
    private MessageSource messages;

    /**
     * Retrieve the localized display name for <code>id</code>.
     * @param weapon ennumeration
     * @return
     */
    public String getLocalDisplayName(EWeapon weapon) {
        return messages.getMessage(weapon.name(), new Object[0], locale.getCurrentLocal());
    }
    /**
     * Retrieve the localized display name for <code>id</code>.
     * @param ware
     * @return
     */
    public String getLocalDisplayName(EWare ware){
        return messages.getMessage(ware.getWareID(), new Object[0], locale.getCurrentLocal());
    }

    public String getLocalDisplayName(ICareer career) {
        if (career instanceof EEconomicCareer) {
            return messages.getMessage(((EEconomicCareer)career).name(), new Object[0], locale.getCurrentLocal());
        } else if (career instanceof EMilitantCareer) {
            return messages.getMessage(((EMilitantCareer)career).name(), new Object[0], locale.getCurrentLocal());
        } else {
            throw new IllegalArgumentException("Unknown career implementation: "+career.getClass().getName());
        }
    }

    public String getLocalDisplayName(ESocialRank rank) {
        return messages.getMessage(rank.name(), new Object[0], locale.getCurrentLocal());
    }
}
