package ch.sahits.game.openpatrician.model.weapon;

import ch.sahits.game.openpatrician.model.IAmountable;

/**
 * This interface defines a weapon.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 23, 2011
 *
 */
public interface IWeapon extends IAmountable{
	/**
	 * As this interface is implemented by an enumeration add this method
	 * @return
	 */
	public String name();

	/**
	 * Compute the price for the weapons to be sold. The price is computed based on the amount
	 * that is available and the amount that is sold. The price is never higher than {@link #getMaxValueBuy()}
	 * and approaches {@link #getMinValueBuy()} assymtotically.
	 * @param availableAmount Amount of the weapon that is available
	 * @param amountToSell Amount of weapon that is to be sold
	 * @return price of the weapon.
	 */
	int computeSellPrice(int availableAmount, int amountToSell);
	/**
	 * Compute the price for the weapons to be bought. The price is computed on the amount
	 * that is available and the amount to be bought. The price is never highter than {@link #getMaxValueBuy()}
	 * plus a weapon specific constant.
	 * @param availableAmount Amount of the weapon that is available
	 * @param amountToBuy Amount of weapon that is to be bought
	 * @return price of the weapon
	 */
	int computeBuyPrice(int availableAmount, int amountToBuy);

}
