/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model;

import ch.sahits.game.openpatrician.collections.NonReplacableMap;
import ch.sahits.game.openpatrician.data.map.Map;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.Difficulty;
import ch.sahits.game.openpatrician.model.EGameSpeed;
import ch.sahits.game.openpatrician.model.EObjective;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IGame;
import ch.sahits.game.openpatrician.model.IMap;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.CityFactory;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.impl.CityState;
import ch.sahits.game.openpatrician.model.factory.BuildingFactory;
import ch.sahits.game.openpatrician.model.impl.GameMap;
import ch.sahits.game.openpatrician.model.people.ReputationCalculator;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.personal.impl.PersonalData;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import javafx.geometry.Dimension2D;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Lazy
@Component
public class GameFactory {
    @Autowired
    private Random rnd;
    @Autowired
    private CityFactory cityFactory;
    @Autowired
    private Date date;
    @Autowired
    private BuildingFactory buildingFactory;
    private NonReplacableMap<String, Object> beanMap = new NonReplacableMap();
    @Autowired
    private ApplicationContext context;
    private List<CityState> cityStates = Lists.newArrayList();

    public IPlayer createPlayer(String name, String lastName, ICity homeTown, boolean male, int cash) {
        int age = this.rnd.nextInt(10) + 17;
        PersonalData pd = new PersonalData(name, lastName, male, homeTown, this.computeRandomBirthDate(age));
        IPlayer player = (IPlayer)this.context.getBean("player", new Object[]{homeTown, pd, cash, ESocialRank.CHANDLER, this});
        this.buildingFactory.createTradingOffice(player, homeTown, 0);
        this.initPlayerInCities(player);
        return player;
    }

    public IAIPlayer createAIPlayer(ICity homeTown, long cash) {
        int age = this.rnd.nextInt(15) + 17;
        IAIPlayer player = (IAIPlayer)this.context.getBean("aiPlayer", new Object[]{homeTown, cash, this.computeRandomBirthDate(age), this});
        this.buildingFactory.createTradingOffice(player, homeTown, 0);
        this.initPlayerInCities(player);
        return player;
    }

    private void initPlayerInCities(IPlayer player) {
        for (ICity city : this.cityFactory.getCities()) {
            city.moveIn(player);
        }
    }

    public IMap createMap(String mapName) throws IOException {
        this.cityFactory.initializeCityCache(mapName);
        Map m = this.cityFactory.getMap();
        GameMap map = (GameMap)this.context.getBean(IMap.class);
        Dimension2D dim = new Dimension2D((double)m.getDimension().getX().shortValue(), (double)m.getDimension().getY().shortValue());
        map.setup(this.date, this.cityFactory.getCities(), dim, m.getImageName());
        return map;
    }

    public IGame createGame(IMap map, EObjective objective, Difficulty difficulty, EGameSpeed speed, int startYear) {
        if (!this.beanMap.containsKey((Object)"game")) {
            this.beanMap.put((Object)"game", this.context.getBean("game", new Object[]{objective, difficulty, speed}));
        }
        return (IGame)this.beanMap.get((Object)"game");
    }

    public IGame getGame() {
        return (IGame)this.beanMap.get((Object)"game");
    }

    private DateTime computeRandomBirthDate(int age) {
        int year = this.date.getStartYear() - age;
        int month = this.rnd.nextInt(12) + 1;
        int day = month == 2 ? this.rnd.nextInt(28) + 1 : (month == 4 || month == 6 || month == 9 || month == 11 ? this.rnd.nextInt(30) + 1 : this.rnd.nextInt(31) + 1);
        return new DateTime(year, month, day, 0, 0);
    }

    public CityState getCityState(ICity city) {
        if (this.cityStates.contains(city)) {
            return this.cityStates.get(this.cityStates.indexOf(city));
        }
        CityState state = this.initCityPropertyState(city);
        return state;
    }

    private CityState initCityPropertyState(ICity city) {
        CityState state = (CityState)this.context.getBean("cityState", new Object[]{city});
        this.cityStates.add(state);
        return state;
    }

    public ReputationCalculator getReputationCalculator() {
        return (ReputationCalculator)this.context.getBean(ReputationCalculator.class);
    }

    public ICompany createCompany(IPlayer owner, ICity homeTown, long cash) {
        return (ICompany)this.context.getBean("company", new Object[]{owner, homeTown, cash});
    }
}

