/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.building.impl;

import ch.sahits.game.openpatrician.model.building.ISteward;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public class Steward
implements ISteward {
    private int expertiseLevel = 0;
    private int salary = 5;
    private IntegerProperty totalProfit = new SimpleIntegerProperty(0);

    public Steward() {
        this.totalProfit.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldProfit, Number newProfit) {
                if (newProfit.intValue() >= 10000 + Steward.this.expertiseLevel * 10000) {
                    Steward.this.expertiseLevel++;
                    Steward.this.totalProfit.setValue((Number)0);
                }
            }
        });
    }

    @Override
    public int getTotalProfitOnExperianceLevel() {
        return this.totalProfit.get();
    }

    @Override
    public void updateProfit(int profit) {
        this.totalProfit.setValue((Number)(this.totalProfit.get() + profit));
    }

    @Override
    public double getDiscountFactor() {
        return 0.95 - 0.05 * (double)this.expertiseLevel;
    }

    @Override
    public int getExpertiseLevel() {
        return this.expertiseLevel;
    }

    @Override
    public int getSalary() {
        return this.salary;
    }
}

