/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.collections.NonReplacableMap;
import ch.sahits.game.openpatrician.data.map.Production;
import ch.sahits.game.openpatrician.javafx.bindings.LateIntegerBinding;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.IBuilding;
import ch.sahits.game.openpatrician.model.city.EKontorType;
import ch.sahits.game.openpatrician.model.city.EPopulationClass;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.impl.CityState;
import ch.sahits.game.openpatrician.model.city.impl.Contributions;
import ch.sahits.game.openpatrician.model.factory.PlayerInteractionFactory;
import ch.sahits.game.openpatrician.model.impl.WareHolding;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.personal.IReputation;
import ch.sahits.game.openpatrician.model.personal.impl.Reputation;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.util.PropertyLoader;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.ResourceBundle;
import javafx.beans.Observable;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.geometry.Point2D;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@Prototype
public class City
extends WareHolding
implements ICity {
    private final Logger logger = Logger.getLogger(this.getClass());
    @Autowired
    private Random rnd;
    private final IWare[] effectiveProduction;
    private final IWare[] ineffectiveProduction;
    private String name;
    private final String nameTemplate;
    private final EKontorType kontorType;
    @Autowired
    private PlayerInteractionFactory interactionFactory;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    private final Point2D coordinates;
    private final Map<IWare, DateTime> missingWares = new HashMap<IWare, DateTime>();
    private List<IBuilding> buildings = new ArrayList<IBuilding>();
    private Map<IPlayer, IReputation> reputation = new HashMap<IPlayer, IReputation>();
    private Map<IPlayer, Contributions> playersContributions = new HashMap<IPlayer, Contributions>();
    private final Map<EPopulationClass, IntegerProperty> population = new NonReplacableMap();
    private LateIntegerBinding totalPopulation = new LateIntegerBinding(){

        protected int computeValue() {
            return City.this.internalPopulationCount();
        }
    };
    private CityState cityState;
    @Autowired
    private Date date;

    public City(ch.sahits.game.openpatrician.data.map.City city) {
        int i;
        Production production = city.getProduction();
        Preconditions.checkNotNull((Object)city.getName(), (Object)"The city does not define a name");
        this.nameTemplate = city.getName();
        Preconditions.checkArgument((!production.getEffective().getWare().isEmpty() ? 1 : 0) != 0, (Object)("The city " + this.nameTemplate + " does not contain the effectiveProduction property"));
        Preconditions.checkArgument((!production.getIneffective().getWare().isEmpty() ? 1 : 0) != 0, (Object)("The city " + this.nameTemplate + " does not contain the ineffectiveProduction property"));
        Preconditions.checkNotNull((Object)city.getKontorType(), (Object)("The city " + this.nameTemplate + " does not define the kontor type."));
        Preconditions.checkNotNull((Object)city.getLocation().getX(), (Object)("The city " + this.nameTemplate + " does not contain the city location"));
        Preconditions.checkNotNull((Object)city.getLocation().getY(), (Object)("The city " + this.nameTemplate + " does not contain the city location"));
        this.effectiveProduction = new EWare[production.getEffective().getWare().size()];
        for (i = 0; i < production.getEffective().getWare().size(); ++i) {
            this.effectiveProduction[i] = EWare.valueOf(production.getEffective().getWare().get(i));
        }
        this.ineffectiveProduction = new EWare[production.getIneffective().getWare().size()];
        for (i = 0; i < production.getIneffective().getWare().size(); ++i) {
            this.ineffectiveProduction[i] = EWare.valueOf(production.getIneffective().getWare().get(i));
        }
        this.kontorType = EKontorType.valueOf(city.getKontorType());
        short x = city.getLocation().getX();
        short y = city.getLocation().getY();
        this.coordinates = new Point2D((double)x, (double)y);
    }

    @PostConstruct
    private void init() {
        this.name = this.messageSource.getMessage(this.nameTemplate, new Object[0], this.locale.getCurrentLocal());
        this.initWares();
        this.initPopulation();
    }

    City(String configFileName) throws IOException {
        String n;
        int i;
        String[] wareNames;
        Properties props = PropertyLoader.loadProperties((String)configFileName);
        if (props.getProperty("effectiveProduction") == null) {
            throw new IOException("The property file " + configFileName + " does not contain the effectiveProduction property");
        }
        if (props.getProperty("ineffectiveProduction") == null) {
            throw new IOException("The property file " + configFileName + " does not contain the ineffectiveProduction property");
        }
        if (props.getProperty("name") == null) {
            throw new IOException("The property file " + configFileName + " does not contain the name property");
        }
        if (props.getProperty("kontorType") == null) {
            throw new IOException("The property file " + configFileName + " does not contain the kontorType property");
        }
        if (props.getProperty("location.x") == null || props.getProperty("location.y") == null) {
            throw new IOException("The property file " + configFileName + " does not contain the city location");
        }
        if (props.getProperty("effectiveProduction").trim().length() > 0) {
            wareNames = props.getProperty("effectiveProduction").split(",");
            this.effectiveProduction = new EWare[wareNames.length];
            for (i = 0; i < wareNames.length; ++i) {
                this.effectiveProduction[i] = EWare.valueOf(wareNames[i]);
            }
        } else {
            this.effectiveProduction = null;
        }
        if (props.getProperty("ineffectiveProduction").trim().length() > 0) {
            wareNames = props.getProperty("ineffectiveProduction").split(",");
            this.ineffectiveProduction = new EWare[wareNames.length];
            for (i = 0; i < wareNames.length; ++i) {
                this.ineffectiveProduction[i] = EWare.valueOf(wareNames[i]);
            }
        } else {
            this.ineffectiveProduction = null;
        }
        this.nameTemplate = n = props.getProperty("name");
        ResourceBundle messages = ResourceBundle.getBundle("ModelMessages", this.locale.getCurrentLocal());
        this.name = messages.getString(n);
        this.kontorType = EKontorType.valueOf(props.getProperty("kontorType"));
        int x = Integer.parseInt(props.getProperty("location.x"));
        int y = Integer.parseInt(props.getProperty("location.y"));
        this.coordinates = new Point2D((double)x, (double)y);
        this.date = new Date(2013);
        this.initPopulation();
        this.initWares();
    }

    protected void initWares() {
        for (EWare ware : EWare.values()) {
            boolean hasWare;
            boolean bl = hasWare = this.rnd.nextInt(7) % 7 != 0;
            if (hasWare) {
                int amount = this.rnd.nextInt(159) + 1;
                this.addNewWare(ware, amount);
                continue;
            }
            this.addNewWare(ware, 0);
        }
    }

    private void initPopulation() {
        int pop = 1000 + (int)Math.abs(this.rnd.nextDouble() * 4000.0);
        int diffPoor = (int)((this.rnd.nextDouble() - 0.5) * 7.0);
        int poor = (int)((60.0 + (double)diffPoor) / 100.0 * (double)pop);
        int begger = this.calculateInitialBeggarCount(pop);
        this.setPopulation(begger, EPopulationClass.BEGGAR);
        this.setPopulation(poor, EPopulationClass.POOR);
        int medium = (pop - poor) * 2 / 3;
        int rich = pop - poor - medium;
        this.setPopulation(medium, EPopulationClass.MEDIUM);
        this.setPopulation(rich, EPopulationClass.RICH);
    }

    private int calculateInitialBeggarCount(int totalPopulation) {
        int beerWareAmounts = this.getWare(EWare.BEER).getAmount();
        int fishWareAmounts = this.getWare(EWare.FISH).getAmount();
        int grainWareAmounts = this.getWare(EWare.GRAIN).getAmount();
        int baseAmount = totalPopulation / 100;
        double factorAvailablility = 1.0;
        if (beerWareAmounts == 0) {
            factorAvailablility -= 0.25;
        }
        if (fishWareAmounts == 0) {
            factorAvailablility -= 0.25;
        }
        if (grainWareAmounts == 0) {
            factorAvailablility -= 0.25;
        }
        double amountFactor = 1.0;
        if (beerWareAmounts > 100) {
            factorAvailablility += 0.25;
        }
        if (fishWareAmounts > 50) {
            factorAvailablility += 0.25;
        }
        if (grainWareAmounts > 20) {
            factorAvailablility += 0.25;
        }
        double randomFactor = this.rnd.nextDouble() * 2.0 + 1.0;
        return (int)((double)baseAmount * factorAvailablility * amountFactor * randomFactor);
    }

    private int internalPopulationCount() {
        int count = 0;
        for (IntegerProperty i : this.population.values()) {
            count += i.get();
        }
        return count;
    }

    @Override
    public IntegerBinding getPopulationBinding() {
        return this.totalPopulation;
    }

    @Override
    public void setPopulation(int population, EPopulationClass popClass) {
        SimpleIntegerProperty populationProperty = new SimpleIntegerProperty(population);
        this.population.put(popClass, (IntegerProperty)populationProperty);
        this.totalPopulation.bind((Observable)populationProperty);
    }

    @Override
    public int getPopulation(EPopulationClass popclass) {
        return this.population.get((Object)popclass).get();
    }

    @Override
    public IntegerProperty getPopulationProperty(EPopulationClass popclass) {
        return this.population.get((Object)popclass);
    }

    @Override
    public List<IBuilding> getBuildings() {
        return Collections.unmodifiableList(this.buildings);
    }

    @Override
    public void build(IBuilding building) {
        this.buildings.add(building);
    }

    @Override
    public void tearDown(IBuilding building) {
        this.buildings.remove(building);
    }

    @Override
    public IReputation getReputation(IPlayer player) {
        return this.reputation.get(player);
    }

    @Override
    public void moveIn(IPlayer player) {
        Reputation rep = new Reputation(this, player);
        this.reputation.put(player, rep);
        this.playersContributions.put(player, this.interactionFactory.createContribution());
    }

    @Override
    public ESocialRank getSocialRank() {
        return ESocialRank.CHANDLER;
    }

    @Override
    public int move(IWare ware, int amount, IPlayer player) {
        int moved = super.move(ware, amount, player);
        if (moved < 0) {
            if (this.getWare(ware).getAmount() == 0) {
                this.missingWares.put(ware, this.date.getCurrentDate());
            }
        } else if (moved > 0 && this.missingWares.containsKey(ware)) {
            this.missingWares.remove(ware);
        }
        if (player != null) {
            Contributions contrib = this.playersContributions.get(player);
            contrib.contribute(ware, moved);
        }
        return moved;
    }

    @Override
    public int getContribution(IPlayer player, IWare ware) {
        Contributions contribs = this.playersContributions.get(player);
        if (contribs != null) {
            return contribs.getContribution(ware);
        }
        this.logger.warn((Object)("Player " + player + " has no contribution for " + ware));
        return 0;
    }

    @Override
    public Map<IWare, DateTime> getMissingWares() {
        return ImmutableMap.copyOf(this.missingWares);
    }

    @Override
    public List<IPlayer> getResidentPlayers() {
        return ImmutableList.copyOf(this.reputation.keySet());
    }

    @Override
    public String getUniqueID() {
        return this.getName();
    }

    @Override
    public IWare[] getEffectiveProduction() {
        return this.effectiveProduction;
    }

    @Override
    public IWare[] getIneffectiveProduction() {
        return this.ineffectiveProduction;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public EKontorType getKontorType() {
        return this.kontorType;
    }

    @Override
    public Point2D getCoordinates() {
        return this.coordinates;
    }

    @Override
    public CityState getCityState() {
        return this.cityState;
    }

    @Override
    public void setCityState(CityState cityState) {
        this.cityState = cityState;
    }
}

