/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.city.CityProduction;
import ch.sahits.game.openpatrician.model.city.EPopulationClass;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.IShipyard;
import ch.sahits.game.openpatrician.model.city.PopulationConsume;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.factory.StateFactory;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@Prototype
public class CityState {
    @Autowired
    private Random rnd;
    @Value(value="${ware.surplus.treshold}")
    private double surplusThreshold;
    private ICity city;
    private Map<IWare, Double> consumed = new HashMap<IWare, Double>();
    private Map<IWare, Double> produced = new HashMap<IWare, Double>();
    @Autowired
    private CityProduction production;
    private TavernState tavernState;
    private IShipyard shipyardState;
    @Autowired
    private PopulationConsume consume;
    @Autowired
    private StateFactory stateFactory;

    public CityState(ICity city) {
        this.city = city;
    }

    @PostConstruct
    private void initCity() {
        EWare[] wares;
        this.shipyardState = this.stateFactory.createShipYard(this.city);
        for (EWare ware : wares = EWare.values()) {
            this.consumed.put(ware, 0.0);
            this.produced.put(ware, 0.0);
        }
        this.tavernState = this.stateFactory.createTavernState(this.city);
        this.city.setCityState(this);
    }

    public void consumeWares() {
        EWare[] wares = EWare.values();
        EPopulationClass[] popClasses = EPopulationClass.values();
        for (EWare ware : wares) {
            double amount = this.consumed.get(ware);
            for (EPopulationClass popClass : popClasses) {
                amount += this.consume.getNeed(ware, popClass, this.city.getPopulation(popClass));
            }
            this.consumed.put(ware, amount);
        }
        for (Map.Entry<IWare, Double> entry : this.consumed.entrySet()) {
            if (!(entry.getValue() >= 1.0)) continue;
            int whole = (int)Math.rint(Math.floor(entry.getValue()));
            this.consumed.put(entry.getKey(), entry.getValue() - (double)whole);
            this.city.move(entry.getKey(), -whole, null);
        }
    }

    public void produceWares() {
        double amount;
        IWare[] wares;
        for (IWare ware : wares = this.city.getEffectiveProduction()) {
            amount = this.produced.get(ware);
            this.produced.put(ware, amount += (double)this.production.getEfficientProduction(ware) / 14.0);
        }
        for (IWare ware : wares = this.city.getIneffectiveProduction()) {
            amount = this.produced.get(ware);
            this.produced.put(ware, amount += (double)this.production.getInefficientProduction(ware) / 14.0);
        }
        for (Map.Entry<IWare, Double> entry : this.produced.entrySet()) {
            if (!(entry.getValue() >= 1.0)) continue;
            int whole = (int)Math.rint(Math.floor(entry.getValue()));
            this.produced.put(entry.getKey(), entry.getValue() - (double)whole);
            this.city.move(entry.getKey(), whole, null);
        }
    }

    public Optional<IWare> findMostNeededWare() {
        Map<IWare, DateTime> missing = this.city.getMissingWares();
        DateTime earliest = null;
        IWare result = null;
        for (Map.Entry<IWare, DateTime> entry : missing.entrySet()) {
            if (earliest != null && !entry.getValue().isBefore((ReadableInstant)earliest)) continue;
            earliest = entry.getValue();
            result = entry.getKey();
        }
        return Optional.fromNullable(result);
    }

    public Optional<IWare> findWareWithMostSurplus() {
        ArrayList<EWare> surplus = new ArrayList<EWare>();
        for (EWare ware : EWare.values()) {
            AmountablePrice<IWare> amount = this.city.getWare(ware);
            double actualPrice = amount.getAVGPrice();
            int minPrice = ware.getMinValueSell();
            double val = (double)minPrice / actualPrice - 1.0;
            if (!(val <= this.surplusThreshold)) continue;
            surplus.add(ware);
        }
        if (surplus.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of(surplus.get(this.rnd.nextInt(surplus.size())));
    }

    public ICity getCity() {
        return this.city;
    }

    public TavernState getTavernState() {
        return this.tavernState;
    }

    public IShipyard getShipyardState() {
        return this.shipyardState;
    }
}

