/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.model.city.impl.ILoanProposal;
import java.beans.ConstructorProperties;

public class LoanProposal
implements ILoanProposal {
    private final double interest;
    private final int amount;
    private final int durationInWeeks;

    public static LoanProposalBuilder builder() {
        return new LoanProposalBuilder();
    }

    @ConstructorProperties(value={"interest", "amount", "durationInWeeks"})
    public LoanProposal(double interest, int amount, int durationInWeeks) {
        this.interest = interest;
        this.amount = amount;
        this.durationInWeeks = durationInWeeks;
    }

    @Override
    public double getInterest() {
        return this.interest;
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public int getDurationInWeeks() {
        return this.durationInWeeks;
    }

    public static class LoanProposalBuilder {
        private double interest;
        private int amount;
        private int durationInWeeks;

        LoanProposalBuilder() {
        }

        public LoanProposalBuilder interest(double interest) {
            this.interest = interest;
            return this;
        }

        public LoanProposalBuilder amount(int amount) {
            this.amount = amount;
            return this;
        }

        public LoanProposalBuilder durationInWeeks(int durationInWeeks) {
            this.durationInWeeks = durationInWeeks;
            return this;
        }

        public LoanProposal build() {
            return new LoanProposal(this.interest, this.amount, this.durationInWeeks);
        }

        public String toString() {
            return "LoanProposal.LoanProposalBuilder(interest=" + this.interest + ", amount=" + this.amount + ", durationInWeeks=" + this.durationInWeeks + ")";
        }
    }
}

