/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IMap;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.IShipDueDate;
import ch.sahits.game.openpatrician.model.city.IShipyard;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.ShipFactory;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
public class ShipyardState
implements IShipyard {
    private static final int BUILD_TIME_SNAIKKA = 30;
    private static final int BUILD_TIME_CRAYER = 40;
    private static final int BUILD_TIME_COG = 60;
    private static final int BUILD_TIME_HOLK = 80;
    private static final int REPAIR_TIME_SNAIKKA = 1;
    private static final int REPAIR_TIME_CRAYER = 2;
    private static final int REPAIR_TIME_COG = 4;
    private static final int REPAIR_TIME_HOLK = 5;
    private static final int MATERIAL_UNIT_COST = 30;
    private static final int BASE_DAY_SALERY = 5;
    private static final Optional<TimedTask> ABSENT_TIMED_TASK = Optional.absent();
    private final Map<IShipDueDate, Optional<TimedTask>> repairList = Maps.newHashMap();
    private final Map<IShipDueDate, Optional<TimedTask>> buildList = Maps.newHashMap();
    private final Map<IShipDueDate, Optional<TimedTask>> refitList = Maps.newHashMap();
    private double experience;
    @Autowired
    private Date date;
    @Autowired
    private Random rnd;
    private final ICity city;
    @Autowired
    private TimedUpdatableTaskList taskList;
    @Autowired
    private ShipFactory shipUtility;
    @Autowired
    private IMap map;

    public ShipyardState(ICity city) {
        this.city = city;
    }

    @PostConstruct
    public void initializeExperience() {
        int mapWidth = (int)this.map.getDimension().getWidth();
        double eastFactor = this.city.getCoordinates().getX() / (double)mapWidth / 0.5;
        double startYearPart = Math.max((this.date.getStartYear() - 1430) / 100, 0);
        this.experience = Math.max(startYearPart - eastFactor, 0.0);
        Preconditions.checkArgument((this.experience >= 0.0 ? 1 : 0) != 0, (Object)"Experiance must be positive");
    }

    @Override
    public List<IShipDueDate> getShipBuildingList() {
        this.cleanup();
        return ImmutableList.copyOf(this.buildList.keySet());
    }

    @Override
    public void addShipBuildingOrder(IShipDueDate dueDate, Optional<TimedTask> task) {
        this.buildList.put(dueDate, task);
    }

    @Override
    public void addShipBuildingOrder(IShipDueDate dueDate) {
        this.buildList.put(dueDate, ABSENT_TIMED_TASK);
    }

    @Override
    public void cancelShipBuildingOrder(DateTime finish) {
        this.cleanup();
        Iterator<IShipDueDate> iterator = this.buildList.keySet().iterator();
        while (iterator.hasNext()) {
            IShipDueDate dueDate = iterator.next();
            if (!dueDate.getDueDate().equals((Object)finish)) continue;
            Optional<TimedTask> task = this.buildList.get(dueDate);
            if (task.isPresent()) {
                this.taskList.remove((TimedTask)task.get());
            }
            iterator.remove();
            break;
        }
    }

    @Override
    public List<IShipDueDate> getShipRepairList() {
        this.cleanup();
        return ImmutableList.copyOf(this.repairList.keySet());
    }

    @Override
    public void addShipRepairOrder(IShipDueDate dueDate, Optional<TimedTask> task) {
        this.repairList.put(dueDate, task);
        this.experience = Math.max(this.experience + 0.005, 1.0);
    }

    @Override
    public int calculateRepairMaterialCosts(IShip ship, int damage) {
        double shipSize = this.getShipSize(ship);
        int materialCosts = (int)((double)(damage * 10) * shipSize * 30.0);
        return materialCosts;
    }

    private double getShipSize(IShip ship) {
        double shipSize = 0.0;
        switch (ship.getShipType()) {
            case SNAIKKA: {
                shipSize = 1.0;
                break;
            }
            case CRAYER: {
                shipSize = 1.5;
                break;
            }
            case COG: {
                shipSize = 2.5;
                break;
            }
            case HOLK: {
                shipSize = 5.0;
            }
        }
        return shipSize;
    }

    @Override
    public int calculateRepairCosts(int repairTime, int materialCosts) {
        return repairTime * this.calculateSaleryPerDay() + materialCosts;
    }

    @Override
    public void addShipToRepairList(IShipDueDate dueDate) {
        this.repairList.put(dueDate, ABSENT_TIMED_TASK);
    }

    private int calculateSaleryPerDay() {
        return (int)(5.0 * (1.0 + this.experience * 10.0));
    }

    @Override
    public void cancelRepair(IShip ship) {
        this.cleanup();
        Iterator<IShipDueDate> iterator = this.repairList.keySet().iterator();
        while (iterator.hasNext()) {
            IShipDueDate dueDate = iterator.next();
            if (!dueDate.getShip().equals(ship)) continue;
            Optional<TimedTask> task = this.repairList.get(dueDate);
            if (task.isPresent()) {
                this.taskList.remove((TimedTask)task.get());
            }
            iterator.remove();
            ship.setAvailable(true);
            break;
        }
    }

    @Override
    public void addShipRefitOrder(IShipDueDate dueDate, Optional<TimedTask> task) {
        this.refitList.put(dueDate, task);
    }

    @Override
    public int calculateRefitTime(EShipType type) {
        return this.calculateBuildTime(type) / 10;
    }

    @Override
    public void addToRefitList(IShipDueDate dueDate) {
        this.refitList.put(dueDate, ABSENT_TIMED_TASK);
    }

    @Override
    public DateTime getBuildCompleteDate(EShipType type) {
        this.cleanup();
        DateTime lastOrderFinished = this.date.getCurrentDate();
        for (IShipDueDate dueDate : this.buildList.keySet()) {
            if (!dueDate.getDueDate().isAfter((ReadableInstant)lastOrderFinished)) continue;
            lastOrderFinished = dueDate.getDueDate();
        }
        int buildTime = this.calculateBuildTime(type);
        return lastOrderFinished.plusDays(buildTime);
    }

    @Override
    public int calculateBuildTime(EShipType type) {
        int baseBuildTime = 0;
        switch (type) {
            case SNAIKKA: {
                baseBuildTime = 30;
                break;
            }
            case CRAYER: {
                baseBuildTime = 40;
                break;
            }
            case COG: {
                baseBuildTime = 60;
                break;
            }
            case HOLK: {
                baseBuildTime = 80;
            }
        }
        return (int)Math.rint((double)baseBuildTime + (1.0 - this.experience) * (double)baseBuildTime);
    }

    @Override
    public int calculateRepairTime(EShipType type) {
        int baseRepairTime = 0;
        switch (type) {
            case SNAIKKA: {
                baseRepairTime = 1;
                break;
            }
            case CRAYER: {
                baseRepairTime = 2;
                break;
            }
            case COG: {
                baseRepairTime = 4;
                break;
            }
            case HOLK: {
                baseRepairTime = 5;
            }
        }
        return (int)Math.rint((double)baseRepairTime + (1.0 - this.experience) * (double)baseRepairTime);
    }

    public void cleanup() {
        IShipDueDate dueDate;
        DateTime now = this.date.getCurrentDate();
        Iterator<IShipDueDate> iterator = this.buildList.keySet().iterator();
        while (iterator.hasNext()) {
            dueDate = iterator.next();
            if (!dueDate.getDueDate().isBefore((ReadableInstant)now)) continue;
            iterator.remove();
        }
        iterator = this.repairList.keySet().iterator();
        while (iterator.hasNext()) {
            dueDate = iterator.next();
            if (!dueDate.getDueDate().isBefore((ReadableInstant)now)) continue;
            iterator.remove();
        }
        iterator = this.refitList.keySet().iterator();
        while (iterator.hasNext()) {
            dueDate = iterator.next();
            if (!dueDate.getDueDate().isBefore((ReadableInstant)now)) continue;
            iterator.remove();
        }
    }

    @Override
    public int calculateRefitCosts(EShipType type, int levels) {
        return this.calculateRefitTime(type) * levels * this.calculateSaleryPerDay();
    }

    @Override
    public int calculateConstructionCosts(EShipType type) {
        return this.calculateBuildTime(type) * this.calculateSaleryPerDay();
    }

    @Override
    public EShipType[] getBuildableShipTypes() {
        if (this.date.getCurrentDate().getYear() > 1450 && this.experience > 0.4) {
            return new EShipType[]{EShipType.SNAIKKA, EShipType.CRAYER, EShipType.COG, EShipType.HOLK};
        }
        if (this.date.getCurrentDate().getYear() > 1420 && this.experience > 0.2) {
            return new EShipType[]{EShipType.SNAIKKA, EShipType.CRAYER, EShipType.COG};
        }
        return new EShipType[]{EShipType.SNAIKKA, EShipType.CRAYER};
    }

    @Override
    public ICity getCity() {
        return this.city;
    }
}

