/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.event;

import ch.sahits.game.event.data.ClockTick;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.joda.time.DateTimeComparator;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class TimedUpdatableTaskList {
    @Autowired
    private Date date;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    private final TreeSet<TimedTask> sortedEvents;

    @PostConstruct
    public void registerWithClock() {
        this.clientServerEventBus.register((Object)this);
    }

    public TimedUpdatableTaskList() {
        Comparator<TimedTask> comparator = new Comparator<TimedTask>(){
            private final DateTimeComparator dateTimeComparator = DateTimeComparator.getInstance();

            @Override
            public int compare(TimedTask task1, TimedTask task2) {
                return this.dateTimeComparator.compare((Object)task1.getExecutionTime(), (Object)task2.getExecutionTime());
            }
        };
        this.sortedEvents = new TreeSet<TimedTask>(comparator);
    }

    public void add(TimedTask task) {
        this.sortedEvents.add(task);
    }

    public void remove(TimedTask task) {
        this.sortedEvents.remove(task);
    }

    @Subscribe
    public void handleClockTick(ClockTick event) {
        DateTime now = this.date.getCurrentDate();
        Iterator<TimedTask> iterator = this.sortedEvents.iterator();
        while (iterator.hasNext()) {
            TimedTask task = iterator.next();
            Preconditions.checkNotNull((Object)task.getExecutionTime(), (Object)"The exectution time of the task may not be null");
            if (task.getExecutionTime().isBefore((ReadableInstant)now)) {
                task.run();
                iterator.remove();
            }
            if (!task.getExecutionTime().isAfter((ReadableInstant)now)) continue;
            break;
        }
    }

    TimedTask getFirst() {
        return this.sortedEvents.first();
    }
}

