/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.factory;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.IBuilding;
import ch.sahits.game.openpatrician.model.building.IStorage;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.building.impl.Storage;
import ch.sahits.game.openpatrician.model.building.impl.TradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.BuildingFinished;
import com.google.common.eventbus.AsyncEventBus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class BuildingFactory {
    @Autowired
    private ApplicationContext context;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;

    public IStorage createStorage(IPlayer owner, ICity city) {
        Storage storage = (Storage)this.context.getBean("storage", new Object[]{owner, city});
        return storage;
    }

    public ITradingOffice createTradingOffice(IPlayer owner, ICity city, int value) {
        for (IBuilding building : city.getBuildings()) {
            if (building.getOwner() != owner || !(building instanceof ITradingOffice)) continue;
            throw new IllegalStateException("The player may only obtain one trading office per city");
        }
        TradingOffice office = (TradingOffice)this.context.getBean("tradingOffice", new Object[]{owner, city, value});
        city.build(office);
        this.clientServerEventBus.post((Object)new BuildingFinished(office, owner, city));
        return office;
    }
}

