/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.impl;

import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.Difficulty;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.EGameSpeed;
import ch.sahits.game.openpatrician.model.EObjective;
import ch.sahits.game.openpatrician.model.IGame;
import ch.sahits.game.openpatrician.model.IMap;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
public class Game
implements IGame {
    @Autowired
    private IMap map;
    private final EObjective objective;
    private final Difficulty difficulty;
    private EGameSpeed gameSpeed;
    private boolean fastforward = false;
    @Autowired
    private Date time;
    @Autowired
    @Qualifier(value="clientEventBus")
    protected AsyncEventBus clientEventBus;
    private static boolean constructed = false;

    public Game(EObjective objective, Difficulty difficulty, EGameSpeed speed) {
        Preconditions.checkState((!constructed ? 1 : 0) != 0, (Object)"The game may only be instantiated once.");
        this.objective = objective;
        this.difficulty = difficulty;
        this.gameSpeed = speed;
        constructed = true;
    }

    @PostConstruct
    private void init() {
        this.clientEventBus.register((Object)this);
        switch (this.gameSpeed) {
            case BREAK: {
                this.time.setTickUpdate(0);
                break;
            }
            case SLOW: {
                this.time.setTickUpdate(5);
                break;
            }
            case MEDIUM: {
                this.time.setTickUpdate(30);
                break;
            }
            case FAST: {
                this.time.setTickUpdate(60);
            }
        }
    }

    @Override
    public void setGameSpeed(EGameSpeed speed) {
        this.gameSpeed = speed;
        this.init();
    }

    @Subscribe
    public void handleMessage(DisplayMessage message) {
        this.normalSpeed();
    }

    private void normalSpeed() {
        if (this.fastforward) {
            this.init();
            this.fastforward = false;
            System.out.println("Fall back to normal speed: " + (Object)((Object)this.gameSpeed));
        }
    }

    @Override
    public void fastForward() {
        if (this.gameSpeed != EGameSpeed.FAST) {
            if (this.fastforward) {
                this.normalSpeed();
            } else {
                this.time.setTickUpdate(60);
                this.fastforward = true;
                System.out.println("Move to fast forward");
            }
        }
    }

    @Override
    public boolean isObjectivReached() {
        return false;
    }

    @Override
    public IMap getMap() {
        return this.map;
    }

    @Override
    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    @Override
    public EGameSpeed getGameSpeed() {
        return this.gameSpeed;
    }

    @Override
    public Date getTime() {
        return this.time;
    }
}

